﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace YumeNikkiRandomizer
{
    class Animations : RPGByteData
    {
        List<Animation> animations;
        
        public Animations(FileStream f)
        {
            load(f);
        }
        public Animations()
        {
        }
        
        override public void load(FileStream f)
        {
            animations = M.readDatabaseList<Animation>(f, "Animations", "Animation", ref M.animationNames);
        }
        
        override protected void myWrite()
        {
            M.writeListNoLength<Animation>(animations);
        }
    }
    
    class Animation : RPGDatabaseEntry
    {
        int id = 0;
        string animationName = ""; // 01
        string animationFile = ""; // 02
        bool largeAnimation = false; // 03 (2003)
        List<AnimationTiming> seFlashTimings; // 06
        int scope = 0; // 09
        int yPosition = 2; // 0a
        List<AnimationFrame> frames; // 0c
        
        static string myClass = "Animation";
        Chunks chunks;
        
        public Animation(FileStream f)
        {
            load(f);
        }
        public Animation()
        {
        }
        
        public void load(FileStream f)
        {
            chunks = new Chunks(f, myClass);
            
            id = M.readMultibyte(f);
            
            if (chunks.next(0x01))
                animationName = M.readStringDataName(f, id, ref M.animationNames, M.S_TOTRANSLATE);
            
            if (chunks.next(0x02))
                animationFile = M.readString(f, M.S_FILENAME);
            if (chunks.next(0x03))
                largeAnimation = M.readLengthBool(f);
            
            if (chunks.next(0x06))
                seFlashTimings = M.readList<AnimationTiming>(f);
            
            if (chunks.next(0x09))
                scope = M.readLengthMultibyte(f);
            if (chunks.next(0x0a))
                yPosition = M.readLengthMultibyte(f);
            
            if (chunks.next(0x0c))
                frames = M.readList<AnimationFrame>(f);
            
            M.byteCheck(f, 0x00);
        }
        
        public void write()
        {
            M.writeMultibyte(id);
            
            if (chunks.wasNext(0x01))
                M.writeString(animationName, M.S_TOTRANSLATE);
            if (chunks.wasNext(0x02))
                M.writeString(animationFile, M.S_FILENAME);
            if (chunks.wasNext(0x03))
                M.writeLengthBool(largeAnimation);
            
            if (chunks.wasNext(0x06))
                M.writeList<AnimationTiming>(seFlashTimings);
            
            if (chunks.wasNext(0x09))
                M.writeLengthMultibyte(scope);
            if (chunks.wasNext(0x0a))
                M.writeLengthMultibyte(yPosition);
            
            if (chunks.wasNext(0x0c))
                M.writeList<AnimationFrame>(frames);
            
            M.writeByte(0x00);
        }
        
        public bool isBlank()
        {
            if (animationName != "" // 01
             || animationFile != "" // 02
             || largeAnimation // 03
             || seFlashTimings.Count > 0 // 06
             || scope != 0 // 09
             || yPosition != 2 // 0a
             || frames.Count != 20) // 0c
                return false;
            
            foreach (AnimationFrame frame in frames)
                if (!frame.isBlank())
                    return false;
            
            return true;
        }
    }
    
    class AnimationTiming : RPGByteData
    {
        int id = 0;
        int frame = 0; // 01
        Audio sound; // 02
        int flashRange = 0; // 03
        int flashRed = 31; // 04
        int flashGreen = 31; // 05
        int flashBlue = 31; // 06
        int flashPower = 31; // 07
        int shakeType = 0; // 08 (2003)
        
        List<int> chunkList;
        
        public AnimationTiming(FileStream f)
        {
            load(f);
        }
        public AnimationTiming()
        {
        }
        
        override public void load(FileStream f)
        {
            chunkList = new List<int>();
            
            id = M.readMultibyte(f);
            
            if (Chunks.next(f, 0x01, chunkList))
                frame = M.readLengthMultibyte(f);
            if (Chunks.next(f, 0x02, chunkList))
                sound = new Audio(f);
            if (Chunks.next(f, 0x03, chunkList))
                flashRange = M.readLengthMultibyte(f);
            if (Chunks.next(f, 0x04, chunkList))
                flashRed = M.readLengthMultibyte(f);
            if (Chunks.next(f, 0x05, chunkList))
                flashGreen = M.readLengthMultibyte(f);
            if (Chunks.next(f, 0x06, chunkList))
                flashBlue = M.readLengthMultibyte(f);
            if (Chunks.next(f, 0x07, chunkList))
                flashPower = M.readLengthMultibyte(f);
            if (Chunks.next(f, 0x08, chunkList))
                shakeType = M.readLengthMultibyte(f);
            
            M.byteCheck(f, 0x00);
        }
        
        override protected void myWrite()
        {
            M.writeMultibyte(id);
            
            if (Chunks.wasNext(0x01, chunkList))
                M.writeLengthMultibyte(frame);
            if (Chunks.wasNext(0x02, chunkList))
                sound.write();
            if (Chunks.wasNext(0x03, chunkList))
                M.writeLengthMultibyte(flashRange);
            if (Chunks.wasNext(0x04, chunkList))
                M.writeLengthMultibyte(flashRed);
            if (Chunks.wasNext(0x05, chunkList))
                M.writeLengthMultibyte(flashGreen);
            if (Chunks.wasNext(0x06, chunkList))
                M.writeLengthMultibyte(flashBlue);
            if (Chunks.wasNext(0x07, chunkList))
                M.writeLengthMultibyte(flashPower);
            if (Chunks.wasNext(0x08, chunkList))
                M.writeLengthMultibyte(shakeType);
            
            M.writeByte(0x00);
        }
    }
    
    class AnimationFrame : RPGByteData
    {
        int id = 0;
        List<AnimationCell> cells; // 01
        
        List<int> chunkList;
        
        public AnimationFrame(FileStream f)
        {
            load(f);
        }
        public AnimationFrame()
        {
        }
        
        override public void load(FileStream f)
        {
            chunkList = new List<int>();
            
            id = M.readMultibyte(f);
            
            if (Chunks.next(f, 0x01, chunkList))
                cells = M.readList<AnimationCell>(f);
            
            M.byteCheck(f, 0x00);
        }
        
        override protected void myWrite()
        {
            M.writeMultibyte(id);
            
            if (Chunks.wasNext(0x01, chunkList))
                M.writeList<AnimationCell>(cells);
            
            M.writeByte(0x00);
        }
        
        public bool isBlank()
        {
            if (cells.Count > 0)
                return false;
            
            return true;
        }
    }
    
    class AnimationCell : RPGByteData
    {
        int id = 0;
        int valid = 1; // 01, verbose only
        int pattern = 0; // 02
        int x = 0; // 03
        int y = 0; // 04
        int magnify = 100; // 05
        int red = 100; // 06
        int green = 100; // 07
        int blue = 100; // 08
        int chroma = 100; // 09
        int transparency = 0; // 0a
        
        List<int> chunkList;
        
        public AnimationCell(FileStream f)
        {
            load(f);
        }
        public AnimationCell()
        {
        }
        
        override public void load(FileStream f)
        {
            chunkList = new List<int>();
            
            id = M.readMultibyte(f);
            
            if (Chunks.next(f, 0x01, chunkList))
                valid = M.readLengthMultibyte(f);
            if (Chunks.next(f, 0x02, chunkList))
                pattern = M.readLengthMultibyte(f);
            if (Chunks.next(f, 0x03, chunkList))
                x = M.readLengthMultibyte(f);
            if (Chunks.next(f, 0x04, chunkList))
                y = M.readLengthMultibyte(f);
            if (Chunks.next(f, 0x05, chunkList))
                magnify = M.readLengthMultibyte(f);
            if (Chunks.next(f, 0x06, chunkList))
                red = M.readLengthMultibyte(f);
            if (Chunks.next(f, 0x07, chunkList))
                green = M.readLengthMultibyte(f);
            if (Chunks.next(f, 0x08, chunkList))
                blue = M.readLengthMultibyte(f);
            if (Chunks.next(f, 0x09, chunkList))
                chroma = M.readLengthMultibyte(f);
            if (Chunks.next(f, 0x0a, chunkList))
                transparency = M.readLengthMultibyte(f);
            
            M.byteCheck(f, 0x00);
        }
        
        override protected void myWrite()
        {
            M.writeMultibyte(id);
            
            if (Chunks.wasNext(0x01, chunkList))
                M.writeLengthMultibyte(valid);
            if (Chunks.wasNext(0x02, chunkList))
                M.writeLengthMultibyte(pattern);
            if (Chunks.wasNext(0x03, chunkList))
                M.writeLengthMultibyte(x);
            if (Chunks.wasNext(0x04, chunkList))
                M.writeLengthMultibyte(y);
            if (Chunks.wasNext(0x05, chunkList))
                M.writeLengthMultibyte(magnify);
            if (Chunks.wasNext(0x06, chunkList))
                M.writeLengthMultibyte(red);
            if (Chunks.wasNext(0x07, chunkList))
                M.writeLengthMultibyte(green);
            if (Chunks.wasNext(0x08, chunkList))
                M.writeLengthMultibyte(blue);
            if (Chunks.wasNext(0x09, chunkList))
                M.writeLengthMultibyte(chroma);
            if (Chunks.wasNext(0x0a, chunkList))
                M.writeLengthMultibyte(transparency);
            
            M.writeByte(0x00);
        }
    }
}
